/*
 * TagReadHandlerBase.cpp
 *
 *  Created on: 30.04.2010
 *      Author: stefan.detter
 */

#include "TagReadHandlerBase.h"

#include "../../application/Application.h"
#include "../../application/Reader.h"

TagReadHandlerBase::TagReadHandlerBase(QWidget* mainWidget, Application* application, QObject* parent)
	: QObject(parent)
	, m_mainWidget(mainWidget)
	, m_application(application)
	, m_handlingOn(false)
	, m_flags(0)
{
	connect(application,SIGNAL(readerAttached(Reader*)),
			this,		  SLOT(readerAttached(Reader*)) );
}

TagReadHandlerBase::~TagReadHandlerBase()
{
}

void TagReadHandlerBase::handlingActivated ( bool on )
{
	if(m_handlingOn == on)
		return;

	m_handlingOn = on;
	if(m_handlingOn)
	{
		QStringList readerList = m_application->readerList();
		foreach(QString readerStr, readerList)
		{
			Reader* reader = m_application->reader(readerStr);
			connect(reader, 		SIGNAL(tagEvent(const TagEvent& )),
					this, 			  SLOT(tagEvent(const TagEvent& )), Qt::QueuedConnection);
		}
	}
	else
	{
		QStringList readerList = m_application->readerList();
		foreach(QString readerStr, readerList)
		{
			Reader* reader = m_application->reader(readerStr);
			disconnect(reader, 		SIGNAL(tagEvent(const TagEvent& )),
						this, 		  SLOT(tagEvent(const TagEvent& )));
		}
	}
}

void TagReadHandlerBase::readerAttached(Reader* reader)
{
	if(m_handlingOn)
	{ 
		connect(reader, 		SIGNAL(tagEvent(const TagEvent& )),
				this, 			  SLOT(tagEvent(const TagEvent& )), Qt::QueuedConnection);
	}
}

void TagReadHandlerBase::tagEvent(const TagEvent& /*event*/)
{
}

